/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.mc6809.dasm;

import frc.emul.mc6809.Operand;
import frc.emul.mc6809.dasm.IDasmRegs;
import frc.emul.util.Utils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DasmRegs
implements IDasmRegs {
    private final List<Entry> listA = new ArrayList<Entry>();
    private final List<Entry> listB = new ArrayList<Entry>();
    private final List<Entry> listCC = new ArrayList<Entry>();
    private final List<Entry> listDP = new ArrayList<Entry>();
    private final List<Entry> listX = new ArrayList<Entry>();
    private final List<Entry> listY = new ArrayList<Entry>();
    private final List<Entry> listU = new ArrayList<Entry>();
    private final List<Entry> listS = new ArrayList<Entry>();
    public static final IDasmRegs UNAVAILABLE_REGS = new IDasmRegs(){

        public boolean isDPAvailable(int n) {
            return false;
        }

        public int getDP(int n) {
            throw new UnsupportedOperationException();
        }

        public boolean isAvailable(Operand operand, int n) {
            return false;
        }

        public int getRegS(Operand operand, int n) {
            throw new UnsupportedOperationException();
        }

        public int getRegU(Operand operand, int n) {
            throw new UnsupportedOperationException();
        }
    };

    public void addRegValue(Operand operand, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n > n2) {
            throw new IllegalArgumentException("Invalid value area [$" + Utils.hex(4, n) + "..$" + Utils.hex(4, n2) + "] for " + (Object)((Object)operand));
        }
        if (operand == Operand.REG_D) {
            this.addRegValue(Operand.REG_A, n, n2, n3 >> 8 & 0xFF);
            this.addRegValue(Operand.REG_B, n, n2, n3 & 0xFF);
            return;
        }
        if (operand == Operand.REG_PC) {
            throw new IllegalArgumentException("PC cannot be defined");
        }
        List<Entry> list = this.getValues(operand);
        int n6 = list.size();
        int n7 = 0;
        while (n7 < n6) {
            Entry entry = list.get(n7);
            if (entry.firstAddr > n) break;
            ++n7;
        }
        if (operand.isReg8()) {
            n5 = n3 & 0xFF;
            n4 = n5;
        } else {
            n5 = n3 & 0xFFFF;
            n4 = Utils.extendWord(n5);
        }
        this.insertEntry(new Entry(n, n2, n5, n4), n7, list);
    }

    @Override
    public boolean isAvailable(Operand operand, int n) {
        if (operand == Operand.REG_D) {
            return this.isAvailable(Operand.REG_A, n) && this.isAvailable(Operand.REG_B, n);
        }
        if (operand == Operand.REG_PC) {
            return true;
        }
        return this.getEntry(this.getValues(operand), n) != null;
    }

    @Override
    public boolean isDPAvailable(int n) {
        return this.getEntry(this.listDP, n) != null;
    }

    @Override
    public int getDP(int n) {
        return this.getEntry(this.listDP, (int)n).valueU;
    }

    @Override
    public int getRegS(Operand operand, int n) {
        return this.getEntry(this.getValues((Operand)operand), (int)n).valueU;
    }

    @Override
    public int getRegU(Operand operand, int n) {
        return this.getEntry(this.getValues((Operand)operand), (int)n).valueS;
    }

    private Entry getEntry(List<Entry> list, int n) {
        int n2 = list.size();
        while (n2 > 0) {
            Entry entry = list.get(--n2);
            if (entry.lastAddr < n) {
                return null;
            }
            if (entry.firstAddr > n) continue;
            return entry;
        }
        return null;
    }

    private void insertEntry(Entry entry, int n, List<Entry> list) {
        Entry entry2;
        int n2 = entry.firstAddr;
        int n3 = entry.lastAddr;
        Entry entry3 = entry2 = n > 0 ? list.get(n - 1) : null;
        if (entry2 != null && entry2.lastAddr >= n2) {
            if (entry2.lastAddr > n3) {
                list.add(n, new Entry(n3 + 1, entry2.lastAddr, entry2.valueU, entry2.valueS));
            }
            if (entry2.firstAddr == n2) {
                list.remove(--n);
            } else {
                entry2.lastAddr = n2 - 1;
            }
        }
        while (n < list.size() && list.get((int)n).lastAddr <= n3) {
            list.remove(n);
        }
        if (n < list.size() && list.get((int)n).firstAddr <= n3) {
            list.get((int)n).firstAddr = n3 + 1;
        }
        list.add(n, entry);
    }

    final void dumpList(Operand operand) {
        List<Entry> list = this.getValues(operand);
        System.out.println("Register value areas defined for " + (Object)((Object)operand) + " (" + list.size() + " areas)");
        int n = 0;
        while (n < list.size()) {
            Entry entry = list.get(n);
            System.out.println("  " + Utils.HEX(4, entry.firstAddr) + "-" + Utils.HEX(4, entry.lastAddr) + " -> " + Utils.HEX(2, entry.valueU));
            ++n;
        }
    }

    private List<Entry> getValues(Operand operand) {
        switch (operand) {
            case REG_A: {
                return this.listA;
            }
            case REG_B: {
                return this.listB;
            }
            case REG_CC: {
                return this.listCC;
            }
            case REG_DP: {
                return this.listDP;
            }
            case REG_X: {
                return this.listX;
            }
            case REG_Y: {
                return this.listY;
            }
            case REG_U: {
                return this.listU;
            }
            case REG_S: {
                return this.listS;
            }
        }
        throw new IllegalArgumentException("No list for specified register : " + (Object)((Object)operand));
    }

    private class Entry {
        int firstAddr;
        int lastAddr;
        final int valueU;
        final int valueS;

        Entry(int n, int n2, int n3, int n4) {
            this.firstAddr = n;
            this.lastAddr = n2;
            this.valueU = n3;
            this.valueS = n4;
        }
    }
}

